package com.ejie.ab04b.dao.nora;

import java.util.List;

import com.ejie.ab04b.model.nora.Provincia;

/**
 * ProvinciaDao.
 * 
 * @author GFI
 */
public interface ProvinciaDao {

	/**
	 * Finds a single row in the Provincia table.
	 * 
	 *  provincia
	 *            Provincia
	 *  Provincia
	 *
	 * @param provincia the provincia
	 * @return the provincia
	 */
	Provincia find(Provincia provincia);

	/**
	 * Finds a List of rows in the Provincia table.
	 * 
	 *  provincia
	 *            Provincia
	 *  List
	 *
	 * @param provincia the provincia
	 * @return the list
	 */
	List<Provincia> findAll(Provincia provincia);

	/**
	 * Counts rows in the Provincia table.
	 * 
	 *  provincia
	 *            Provincia
	 *  Long
	 *
	 * @param provincia the provincia
	 * @return the long
	 */
	Long findAllCount(Provincia provincia);

	/**
	 * Find all first.
	 *
	 * @param provincia the provincia
	 * @return the provincia
	 */
	Provincia findAllFirst(Provincia provincia);
}